##!/bin/bash
## Script to fix permissions of accounts
## Original script written by: Vanessa Vasile 5/13/10
## http://thecpaneladmin.com
##
## CHANGELOG
## Version 1.0  - Joseph Still 
##		- Initial Version
## Version 1.1  - Dennis Henry
##		- Added check for beginning of line when obtaining HOMEDIR
## Version 1.2  - Joseph Still
##		- Added public_html permission and final email perm fix
## Version 1.3  - Marcos Velazquez 
##		- Formatted top of Script to include changelog. Yeah, I'm OCD like that.
##		- Changed wide chmods to only public_html
##		- Introduced several user:mail and user:nobody chowns to list
## Version 1.4  - Joseph Still
##   - Added if statement to allow optional user argument. Now it can be run through a loop :D
## Version 1.5  - Joseph Still
##   - Added check to verify the suPHP is actually in use.
## Version 1.6  - Joseph Still
##   - Added verbose flag to all commands to always show what its doing.
## Version 1.7  - Christopher Eldon
##   - Updated the suPHP check to ensure that it is only checking for PHP5, since PHP4 isn't really used anymore.
## Version 1.8  - Joseph Still
##   - Added support for more CGI scripts. 
##   - Added FCGI to handler whitelist.
## Version 1.9  - Joseph Still
##   - Added logic to make email pipe scripts 755
## Version 1.10 - Gabriel Nieves
##   - Removed _vti_pvt check. This is for FrontPage sites which are no longer used.
##   - Added some more validation checks to user inputs
##   - Added validation check for homedir to prevent destroying an entire server
##   - Changed text of errors to more accurately display what error is occurring
## Version 1.11 - Gabriel Nieves
##   - Added logging
## Version 1.12 - Marc Polk
##   - Deprecating script in favor of "Fix Known Home" script
#
# Version 1.11 script begins below
#

function main() {
  [ -d /home/.hd/var/log ] && mkdir -p /home/.hd/var/log/

  local HOMEDIR
  
  if [ -z "$1" ]; then
    read -p "Fix permissions for which cPanel Username? " user;
  else
    user="$1"
  fi
  
  HOMEDIR=$(grep "^${user}:" /etc/passwd | cut -d: -f6)
  
  if [ ! -f /var/cpanel/users/"$user" ]; then
    echo "Error: User file \"/var/cpanel/users/$user\" is missing. This is likely an invalid user."
    return 1
  fi
  
  # the 'nobody' user's homedir is /, prevent it from chpwning a server.
  if [[ "$user" =~ ^(nobody|system|root)$ ]]; then
    echo "Error: This script does not work with system users." >&2
    return 2
  fi
  
  # Prevent destroying a server
  if ![[ $HOMEDIR =~ ^/home[0-9]*/"${user}" ]]; then
    echo "Error: Could not run fix on \"$HOMEDIR\". This is either an invalid or insecure path to recursively change permissions on."
    return 3
  fi
  
  local logfile=/home/.hd/var/log/fixhome.${user}.$(date +"%Y-%m-%d_%H%M").log
  echo "Fixing permissions for $user [Log: ${logfile}]"
  fixHome | tee ${logfile}
  echo "Done fixing permissions for \"$user\". Changes have been logged to: \"${logfile}\""
}

function fixHome() {
  # Fix ownership
  echo "Setting ownership for user $user"

  chown -vR $user:$user $HOMEDIR
  chmod -v 711 $HOMEDIR
  chown -v $user:nobody $HOMEDIR/public_html
  [ -d $HOMEDIR/.htpasswds ] && chown -v $user:nobody $HOMEDIR/.htpasswds
  chown -v $user:mail $HOMEDIR/etc $HOMEDIR/etc/* $HOMEDIR/etc/*/shadow* $HOMEDIR/etc/*/passwd* $HOMEDIR/mail/*/*/maildirsize $HOMEDIR/etc/*/*pwcache $HOMEDIR/etc/*/*pwcache/*

  # Fix permissions
  echo "Setting permissions for user $user"

  find $HOMEDIR/public_html/ -type f -exec chmod -v 644 {} +
  find $HOMEDIR/public_html/ -type d -exec chmod -v 755 {} +

  find $HOMEDIR -type d -name cgi-bin -exec chmod -v 755 {} +
  find $HOMEDIR -type f \( -name "*.cgi" -o -name "*.pl" -o -name "*.py" -o -name "*.perl" \) -exec chmod -v 755 {} +

  while read pipefile; do
    grep -q '#!' "$pipefile" && chmod +x "$pipefile"
  done < <(find $HOMEDIR -type f -name "pipe.php")

  find $HOMEDIR/mail/ ! -user $user -exec chown -v $user:$user {} +
  /scripts/mailperm --verbose --skipserverperm --skipmxcheck $user
}

main "$@"

#echo "This script has been deprecated. Please use the 'Fix Known Home' script instead: https://codesilo.dimenoc.com/support/fix_known_home"
