#!/bin/bash

touch /home/.hd/tmp/disable_php_eol.log
echo "Changing the PHP to 7.3" >> /home/.hd/tmp/disable_php_eol.log 
whmapi1 php_set_system_default_version version='ea-php73'

echo "Removing EOL 5.X PHP RPMs..." >> /home/.hd/tmp/disable_php_eol.log
yum -y remove ea-php5* |tee -a /home/.hd/tmp/disable_php_eol.log
echo "Editing .htaccess to remove the EOL 5.x PHP version on files: " >> /home/.hd/tmp/disable_php_eol.log
find /home -type f -name .htaccess -exec grep -l ea-php5 {} \; |tee -a /home/.hd/tmp/disable_php_eol.log |while read htfile; do  sed -i.eolphp "s@ea-php5.@ea-php73@g" $htfile; done
echo "Editing 5.x php.ini to updated session directory on files: " >> /home/.hd/tmp/disable_php_eol.log
find /home -type f -regex ".*\(php\|\.user\).ini" -exec grep -l ea-php5 {} \; |tee -a /home/.hd/tmp/disable_php_eol.log |while read htfile; do  sed -i.eolphp "s@ea-php5.@ea-php73@g" $htfile; done
echo "Editing  files to see new version on cPanel domains affected by removing 5.x: " >> /home/.hd/tmp/disable_php_eol.log
find /var/cpanel/userdata/ -type f -not -name "*cache" -exec grep -l ea-php5 {} \; |tee -a /home/.hd/tmp/disable_php_eol.log |while read htfile; do  sed -i "s@ea-php5.@ea-php73@g" $htfile; done

echo "Removing EOL 7.0 PHP RPMs..." >> /home/.hd/tmp/disable_php_eol.log
yum -y remove ea-php70* |tee -a /home/.hd/tmp/disable_php_eol.log
echo "Editing .htaccess to remove the EOL 7.0 PHP version on files: " >> /home/.hd/tmp/disable_php_eol.log
find /home -type f -name .htaccess -exec grep -l ea-php70 {} \; |tee -a /home/.hd/tmp/disable_php_eol.log |while read htfile; do  sed -i.eolphp "s@ea-php70@ea-php73@g" $htfile; done
echo "Editing 7.0 php.ini to updated session directory on files: " >> /home/.hd/tmp/disable_php_eol.log
find /home -type f -regex ".*\(php\|\.user\).ini" -exec grep -l ea-php70 {} \; |tee -a /home/.hd/tmp/disable_php_eol.log |while read htfile; do  sed -i.eolphp "s@ea-php70@ea-php73@g" $htfile; done
echo "Editing  files to see new version on cPanel domains affected: " >> /home/.hd/tmp/disable_php_eol.log
find /var/cpanel/userdata/ -type f -not -name "*cache" -exec grep -l ea-php70 {} \; |tee -a /home/.hd/tmp/disable_php_eol.log |while read htfile; do  sed -i "s@ea-php70@ea-php73@g" $htfile; done

#updating cronjobs
echo "Updating cronjobs" >> /home/.hd/tmp/disable_php_eol.log
find /var/spool/cron -type f -exec grep -l ea-php5 {} \; |tee -a /home/.hd/tmp/disable_php_eol.log |while read htfile; do  sed -i "s@ea-php5.@ea-php73@g" $htfile; done
find /var/spool/cron -type f -exec grep -l ea-php70 {} \; |tee -a /home/.hd/tmp/disable_php_eol.log |while read htfile; do  sed -i "s@ea-php70@ea-php73@g" $htfile; done

/usr/local/cpanel/scripts/updateuserdatacache 
