import re
import os
import dns.resolver
import operator

ips = []
usersHosted={}
count = 0
bad_doms = {}
ok_doms={}
fdomains = open('/etc/userdomains')

#Getting IPs server
ifconfig = os.popen("ifconfig").read().split("\n")
for i in ifconfig:
    ip = re.search('inet[\ a-z:]+([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)',i)
    if ip != None and ip.group(1) != "127.0.0.1":
        ips.append(ip.group(1))

domains=fdomains.readlines()
counter1 = 0
for domain in domains:
    parts = domain.split(': ')
    domain = parts[0]
    user = parts[1][:-1]
    if not user in usersHosted:
         usersHosted[user]=False
    if not counter1 % 10 :
         print "Progress: "+str(counter1)+"/"+str(len(domains))+" domains checked"
    counter1 += 1
#Testing resolve domain
    skip = False
    try:
         for test in dns.resolver.query(domain):
             if test.to_text() in ips: # the domain does point to the server, move on
                 skip = True
                 usersHosted[user]=True
                 break
         if skip:
             ok_doms[user+' - '+domain+' - WEB'] = "Hosted on server IP:"+test.to_text()
         else :
             bad_doms[user + ' - ' + domain+' - WEB'] = "Points to "+test.to_text()
    except dns.exception.DNSException, e:
         bad_doms[user + ' - ' + domain+' - WEB'] = 'Does not resolve'
#Testing resolve domain with www
    skip = False
    try:
         for test in dns.resolver.query("www."+domain) :
             if test.to_text() in ips: # the domain does point to the server, move on
                 skip = True
                 usersHosted[user]=True
                 break
         if skip:
             ok_doms[user+' - '+domain+' - Web'] = "WWW Hosted on server IP:"+test.to_text()
         else :
             bad_doms[user + ' - ' + domain+' - Web'] = "WWW Points to "+test.to_text()
    except dns.exception.DNSException, e:
         bad_doms[user + ' - ' + domain+' - Web'] = 'WWW Does not resolve'
#Testing Mail resolver for domain
    try:
         for mxR in dns.resolver.query(domain,"MX"):
            addMX=False
            try:
                for mxIP in dns.resolver.query(mxR.exchange):
                    if mxIP.to_text() in ips:
                        addMX=True
                        usersHosted[user]=True
                        break
                if addMX:
                    ok_doms[user+' - '+domain+' - MAIL'] = "Hosted on server by "+mxR.to_text()
                else:
                    bad_doms[user + ' - ' + domain+' - MAIL'] = "Points to "+mxR.to_text()
            except dns.exception.DNSException, e:
                bad_doms[user+' - '+domain+' - MAIL'] = "MX record wasn't found"+mxR.to_text()
    except dns.exception.DNSException, e:
         bad_doms[user+' - '+domain+' - MAIL'] = "No MX record found"

print "Checking complete."
print "Possible accounts not hosted:"
for users in sorted(usersHosted.iterkeys()):
    if not usersHosted[users]:
        print "User: "+users
print "Details for accounts on:"
#Manage files
fdomains.close()
fgoodDomains=open('/root/auditdomains_good.txt','w')
fbadDomains=open('/root/auditdomains_bad.txt','w')
fbadDomains.writelines("-=-=-= DOMAINS NO HOSTED ON SERVER =-=-=-\nuser - domain - type : reason\n")
for dom in sorted(bad_doms.iterkeys()):
    fbadDomains.writelines("%s: %s\n" % (dom, bad_doms[dom]))
fbadDomains.close()
fgoodDomains.writelines("-=-=-= DOMAINS HOSTED ON SERVER =-=-=-\nuser - domain - type : reason\n")
for dom in sorted(ok_doms.iterkeys()):
    fgoodDomains.writelines("%s: %s\n" % (dom, ok_doms[dom]))
fgoodDomains.close()
print "Domains hosted on server - /root/auditdomains_good.txt"
print "Domains NO hosted on server - /root/auditdomains_bad.txt"
